/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.routing;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.client.button.FilterButtonTogglePress;
import wayoftime.bloodmagic.common.container.item.ContainerFilter;
import wayoftime.bloodmagic.common.item.inventory.InventoryFilter;
import wayoftime.bloodmagic.common.item.inventory.ItemInventory;
import wayoftime.bloodmagic.common.item.routing.CompositeFilterKey;
import wayoftime.bloodmagic.common.item.routing.ICompositeItemFilterProvider;
import wayoftime.bloodmagic.common.item.routing.IFilterKey;
import wayoftime.bloodmagic.common.item.routing.INestableItemFilterProvider;
import wayoftime.bloodmagic.common.item.routing.ItemRouterFilter;
import wayoftime.bloodmagic.common.routing.BasicItemFilter;
import wayoftime.bloodmagic.common.routing.BlacklistItemFilter;
import wayoftime.bloodmagic.common.routing.IItemFilter;
import wayoftime.bloodmagic.util.GhostItemHelper;

public class ItemCompositeFilter
extends ItemRouterFilter
implements MenuProvider,
ICompositeItemFilterProvider {
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack filterStack, Level world, List<Component> tooltip, TooltipFlag flag) {
        int whitelistState;
        boolean isWhitelist;
        tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.compositefilter.desc").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
        if (filterStack.m_41783_() == null) {
            return;
        }
        List<ItemStack> nestedFilters = this.getNestedFilters(filterStack);
        if (nestedFilters.size() > 0) {
            boolean sneaking = Screen.m_96638_();
            if (!sneaking) {
                tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.extraInfo").m_130940_(ChatFormatting.BLUE));
            } else {
                tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.contained_filters").m_130940_(ChatFormatting.BLUE));
                for (ItemStack nestedStack : nestedFilters) {
                    tooltip.add(nestedStack.m_41786_());
                }
            }
        }
        boolean bl = isWhitelist = (whitelistState = this.getCurrentButtonState(filterStack, "blackwhitelist", 0)) == 0;
        if (isWhitelist) {
            tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.filter.whitelist").m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.filter.blacklist").m_130940_(ChatFormatting.GRAY));
        }
        InventoryFilter inv = new InventoryFilter(filterStack);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (isWhitelist) {
                int amount = GhostItemHelper.getItemGhostAmount(stack);
                if (amount > 0) {
                    tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.filter.count", new Object[]{amount, stack.m_41786_()}));
                    continue;
                }
                tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.filter.all", new Object[]{stack.m_41786_()}));
                continue;
            }
            tooltip.add(stack.m_41786_());
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        List<ItemStack> nestedFilters = this.getNestedFilters(stack);
        if (nestedFilters.size() > 0) {
            return super.m_7203_(world, player, hand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Override
    protected IItemFilter getFilterTypeFromConfig(ItemStack filterStack) {
        int state = this.getCurrentButtonState(filterStack, "blackwhitelist", 0);
        if (state == 1) {
            return new BlacklistItemFilter();
        }
        return new BasicItemFilter();
    }

    @Override
    public IFilterKey getFilterKey(ItemStack filterStack, int slot, ItemStack ghostStack, int amount) {
        return null;
    }

    @Override
    public IItemFilter getInputItemFilter(ItemStack filterStack, BlockEntity tile, IItemHandler handler) {
        IItemFilter testFilter = this.getFilterTypeFromConfig(filterStack);
        ArrayList<IFilterKey> filteredList = new ArrayList<IFilterKey>();
        InventoryFilter inv = new InventoryFilter(filterStack);
        List<ItemStack> nestedList = this.getNestedFilters(filterStack);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            int amount = GhostItemHelper.getItemGhostAmount(stack);
            ItemStack ghostStack = GhostItemHelper.getSingleStackFromGhost(stack);
            IFilterKey mainKey = this.getFilterKey(filterStack, i, ghostStack, amount);
            if (nestedList.size() > 0) {
                CompositeFilterKey compositeKey = new CompositeFilterKey(amount);
                if (mainKey != null) {
                    compositeKey.addFilterKey(mainKey);
                }
                for (ItemStack nestedStack : nestedList) {
                    compositeKey.addFilterKey(((INestableItemFilterProvider)nestedStack.m_41720_()).getFilterKey(filterStack, i, ghostStack, amount));
                }
                filteredList.add(compositeKey);
                continue;
            }
            if (mainKey == null) continue;
            filteredList.add(mainKey);
        }
        testFilter.initializeFilter(filteredList, tile, handler, false);
        return testFilter;
    }

    @Override
    public IItemFilter getOutputItemFilter(ItemStack filterStack, BlockEntity tile, IItemHandler handler) {
        IItemFilter testFilter = this.getFilterTypeFromConfig(filterStack);
        ArrayList<IFilterKey> filteredList = new ArrayList<IFilterKey>();
        InventoryFilter inv = new InventoryFilter(filterStack);
        List<ItemStack> nestedList = this.getNestedFilters(filterStack);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            int amount = GhostItemHelper.getItemGhostAmount(stack);
            ItemStack ghostStack = GhostItemHelper.getSingleStackFromGhost(stack);
            if (amount == 0) {
                amount = Integer.MAX_VALUE;
            }
            IFilterKey mainKey = this.getFilterKey(filterStack, i, ghostStack, amount);
            if (nestedList.size() > 0) {
                CompositeFilterKey compositeKey = new CompositeFilterKey(amount);
                if (mainKey != null) {
                    compositeKey.addFilterKey(mainKey);
                }
                for (ItemStack nestedStack : nestedList) {
                    compositeKey.addFilterKey(((INestableItemFilterProvider)nestedStack.m_41720_()).getFilterKey(filterStack, i, ghostStack, amount));
                }
                filteredList.add(compositeKey);
                continue;
            }
            if (mainKey == null) continue;
            filteredList.add(mainKey);
        }
        testFilter.initializeFilter(filteredList, tile, handler, true);
        return testFilter;
    }

    @Override
    public int receiveButtonPress(ItemStack filterStack, String buttonKey, int ghostItemSlot, int currentButtonState) {
        CompoundTag tag = filterStack.m_41783_();
        if (tag == null) {
            filterStack.m_41751_(new CompoundTag());
            tag = filterStack.m_41783_();
        }
        if (buttonKey.equals("blackwhitelist")) {
            int nextState = 0;
            switch (currentButtonState) {
                case 0: {
                    nextState = 1;
                    break;
                }
                default: {
                    nextState = 0;
                }
            }
            tag.m_128405_("button:blackwhitelist", nextState);
            return nextState;
        }
        List<ItemStack> nestedList = this.getNestedFilters(filterStack);
        for (ItemStack nestedStack : nestedList) {
            int nextState = ((INestableItemFilterProvider)nestedStack.m_41720_()).receiveButtonPress(filterStack, buttonKey, ghostItemSlot, currentButtonState);
            if (nextState == -1) continue;
            return nextState;
        }
        return -1;
    }

    @Override
    public int getCurrentButtonState(ItemStack filterStack, String buttonKey, int ghostItemSlot) {
        CompoundTag tag = filterStack.m_41783_();
        if (tag != null && buttonKey.equals("blackwhitelist")) {
            int state = tag.m_128451_("button:blackwhitelist");
            return state;
        }
        List<ItemStack> nestedList = this.getNestedFilters(filterStack);
        for (ItemStack nestedStack : nestedList) {
            int currentState = ((INestableItemFilterProvider)nestedStack.m_41720_()).getCurrentButtonState(filterStack, buttonKey, ghostItemSlot);
            if (currentState == -1) continue;
            return currentState;
        }
        return -1;
    }

    @Override
    public List<Component> getTextForHoverItem(ItemStack filterStack, String buttonKey, int ghostItemSlot) {
        ArrayList<Component> componentList = new ArrayList<Component>();
        int currentState = this.getCurrentButtonState(filterStack, buttonKey, ghostItemSlot);
        if (buttonKey.equals("blackwhitelist")) {
            switch (currentState) {
                case 1: {
                    componentList.add((Component)new TranslatableComponent("filter.bloodmagic.blacklist"));
                    break;
                }
                default: {
                    componentList.add((Component)new TranslatableComponent("filter.bloodmagic.whitelist"));
                }
            }
            return componentList;
        }
        List<ItemStack> nestedList = this.getNestedFilters(filterStack);
        for (ItemStack nestedStack : nestedList) {
            componentList.addAll(((INestableItemFilterProvider)nestedStack.m_41720_()).getTextForHoverItem(filterStack, buttonKey, ghostItemSlot));
        }
        return componentList;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Pair<String, Button.OnPress>> getButtonAction(ContainerFilter container) {
        ArrayList<Pair<String, Button.OnPress>> buttonList = new ArrayList<Pair<String, Button.OnPress>>();
        buttonList.add(Pair.of((Object)"blackwhitelist", (Object)new FilterButtonTogglePress("blackwhitelist", container)));
        List<ItemStack> nestedList = this.getNestedFilters(container.filterStack);
        for (ItemStack nestedStack : nestedList) {
            List<Pair<String, Button.OnPress>> nestedButtonList = ((INestableItemFilterProvider)nestedStack.m_41720_()).getButtonAction(container);
            buttonList.addAll(nestedButtonList);
        }
        return buttonList;
    }

    @Override
    public Pair<Integer, Integer> getTexturePositionForState(ItemStack filterStack, String buttonKey, int currentButtonState) {
        if (buttonKey.equals("blackwhitelist")) {
            switch (currentButtonState) {
                case 1: {
                    return Pair.of((Object)176, (Object)20);
                }
            }
            return Pair.of((Object)176, (Object)0);
        }
        List<ItemStack> nestedList = this.getNestedFilters(filterStack);
        for (ItemStack nestedStack : nestedList) {
            Pair<Integer, Integer> pair = ((INestableItemFilterProvider)nestedStack.m_41720_()).getTexturePositionForState(filterStack, buttonKey, currentButtonState);
            if ((Integer)pair.getLeft() <= 0 && (Integer)pair.getRight() <= 0) continue;
            return pair;
        }
        return Pair.of((Object)0, (Object)0);
    }

    @Override
    public boolean isButtonGlobal(ItemStack filterStack, String buttonKey) {
        return buttonKey.equals("blackwhitelist");
    }

    public List<ItemStack> getNestedFilters(ItemStack mainFilterStack) {
        ArrayList<ItemStack> nestedFilters = new ArrayList<ItemStack>();
        ItemInventory inv = new ItemInventory(mainFilterStack, 9, "filterInventory");
        for (int i = 0; i < 9; ++i) {
            ItemStack testStack = inv.m_8020_(i);
            if (testStack.m_41619_() || !(testStack.m_41720_() instanceof INestableItemFilterProvider)) continue;
            nestedFilters.add(testStack);
        }
        return nestedFilters;
    }

    @Override
    public boolean canReceiveNestedFilter(ItemStack mainFilterStack, ItemStack nestedFilterStack) {
        if (nestedFilterStack.m_41619_()) {
            return false;
        }
        if (!(nestedFilterStack.m_41720_() instanceof INestableItemFilterProvider)) {
            return false;
        }
        boolean hasEmpty = false;
        ItemInventory inv = new ItemInventory(mainFilterStack, 9, "filterInventory");
        for (int i = 0; i < 9; ++i) {
            ItemStack testStack = inv.m_8020_(i);
            if (testStack.m_41619_()) {
                hasEmpty = true;
                continue;
            }
            if (!testStack.m_41720_().equals(nestedFilterStack.m_41720_())) continue;
            return false;
        }
        return hasEmpty;
    }

    @Override
    public ItemStack nestFilter(ItemStack mainFilterStack, ItemStack nestedFilterStack) {
        if (this.canReceiveNestedFilter(mainFilterStack, nestedFilterStack)) {
            ItemStack copyStack = mainFilterStack.m_41777_();
            ItemInventory inv = new ItemInventory(copyStack, 9, "filterInventory");
            for (int i = 0; i < 9; ++i) {
                ItemStack testStack = inv.m_8020_(i);
                if (!testStack.m_41619_()) continue;
                inv.m_6836_(i, nestedFilterStack);
                inv.m_6596_();
                return copyStack;
            }
        }
        return ItemStack.f_41583_;
    }
}

